<?php
  $Seccion      = 'Reportes';
  $SubSeccion   = 'Ventas';
  $NameSec      = 'Reporte de Ventas';
  $UrlImgs      = 'images/cursos';
  $Position   = '../../';
  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');
  require_once($Position.'funciones/extras.php');

  $SecLine      = array($NameSec);

  //Buscador

  $Where = "
    WHERE
      ven.Id != '0'
  ";

  $Bus = '?Filtrar=Ok';

  if( $_GET['Filtrar'] == 'Ok' ){


    $FechaDesde = CambioFechaCompleta($_GET['Desde']);
    $Bus .= "&Desde=".$_GET['Desde'];

    $FechaHasta = CambioFechaCompleta($_GET['Hasta']);
    $Bus .= "&Hasta=".$_GET['Hasta'];

    //Cliente
    if( $_GET['Cliente'] ){
      $FilCli = $_GET['Cliente'];
      $Where .= "
        AND cli.Nombre LIKE '$FilCli%'
      ";
      $Bus .= "&Cliente=".$FilCli;
    }
    //End Cliente

    //Metodo de Pago
    if( $_GET['Metodo'] ){
      $FilMet = $_GET['Metodo'];
      $Left .= "
        LEFT JOIN KB_Pagos pag ON pag.Fk_Venta = ven.Id
      ";
      $Where .= "
        AND pag.Fk_Metodo = '$FilMet'
      ";
      $Bus .= "&Metodo=".$FilMet;
    }
    //End Metodo de Pago

  }else{

    $FechaDesde = date('Y-m-01');
    $Bus .= "&Desde=".$FechaDesde;
    $FechaHasta = date('Y-m-t');
    $Bus .= "&Hasta=".$FechaHasta;

  }

  $Where .= "
    AND (ven.Fecha BETWEEN '".$FechaDesde." 00:00:00' AND '".$FechaHasta." 23:59:59' )
  ";

  $FilDes = CambioFechaInversa($FechaDesde);
  $FilHas = CambioFechaInversa($FechaHasta);
  //End Buscador

  //Ventas
  $Query = "
    SELECT
      ven.Id,
      ven.Folio,
      ven.Documento,
      ven.Sucursal,
      ven.Fecha,
      ven.Total,
      ven.FechaCarga,
      emp.Nombre AS Empresa,
      cli.Nombre AS Cliente
    FROM KB_Ventas ven
    LEFT JOIN KB_Empresas emp ON emp.Id = ven.Fk_Empresa
    LEFT JOIN KB_Clientes cli ON cli.Id = ven.Fk_Cliente
    $Left
      $Where
    ORDER BY ven.Fecha DESC
  ";
  $Ventas = $mysqli->query($Query);

?>

<!DOCTYPE html>
<html lang="en">

<?php require_once($Position.'head.php'); ?>

<body class="fix-sidebar fix-header card-no-border">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <div id="main-wrapper">
      <?php require_once($Position.'header.php'); ?>
      <?php require_once($Position.'menu.php'); ?>
      <div class="page-wrapper">
        <div class="container-fluid">
          <div class="row page-titles">

            <?php require_once($Position.'title.php'); ?>

            <!-- Botones -->
            <div class="col-md-7 align-self-center text-right">
              <div class="btn-group" role="group" aria-label="Basic example">
                <?php if( $Perms[28] ){ ?>
                  <a href="item">
                    <button type="button" class="btn btn-sm btn-secondary">Nuevo<i class="fa fa-plus mar-l-10"></i></button>
                  </a>
                <?php } ?>
              </div>
            </div>
            <!-- End Botones -->

          </div>
          <div class="row">

            <!-- Buscador -->
            <div class="col-sm-12">
              <form method="get">
                <div class="card">
                  <div class="card-body">
                    <div class="row">

                      <!-- Desde -->
                      <div class="col-sm-3">
                        <div class="form-group">
                          <label class="control-label">Desde</label>
                          <input name="Desde" value="<?php echo $FilDes; ?>" type="text" class="form-control datepicker" placeholder="">
                        </div>
                      </div>
                      <!-- End Desde -->

                      <!-- Hasta -->
                      <div class="col-sm-3">
                        <div class="form-group">
                          <label class="control-label">Hasta</label>
                          <input name="Hasta" value="<?php echo $FilHas; ?>" type="text" class="form-control datepicker" placeholder="">
                        </div>
                      </div>
                      <!-- End Hasta -->

                      <!-- Cliente -->
                      <div class="col-sm-3">
                        <div class="form-group">
                          <label class="control-label">Cliente</label>
                          <input name="Cliente" value="<?php echo $FilCli; ?>" type="text" class="form-control form-control-sm" placeholder="">
                        </div>
                      </div>
                      <!-- End Cliente -->

                      <!-- Forma de Pago -->
                      <div class="col-sm-3">
                        <div class="form-group">
                          <label class="control-label">Forma de Pago</label>
                          <select id="Metodo" name="Metodo" class="form-control chosen-select">
                            <option></option>
                            <?php
                              //Metodos
                              $Query = "
                                SELECT
                                  met.Id, met.Metodo
                                FROM KB_PagosMetodos met
                                WHERE
                                  met.Id != '0'
                                ORDER BY met.Metodo ASC
                              ";
                              $Mets = $mysqli->query($Query);
                              mysqli_data_seek($Mets, 0);
                              while($Met = mysqli_fetch_array($Mets)) {
                            ?>
                              <option
                                <?php if( $Met['Id'] == $FilMet ){ echo 'selected="selected"'; } ?>
                                value="<?php echo $Met['Id']; ?>"
                              ><?php echo $Met['Metodo']; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                      </div>
                      <!-- End Forma de PagoHasta -->

                      <!-- Filtrar -->
                      <div class="col-sm-3">
                        <div class="form-group">
                          <label class="control-label">.</label>

                          <!-- Btn Filtrar -->
                          <button class="btn btn-success btn-block" type="submit" name="button">
                            Filtrar <i class="fa fa-search mar-l-5"></i>
                          </button>
                          <!-- End Btn Filtrar -->

                          <input type="hidden" name="Filtrar" value="Ok" />
                        </div>
                      </div>
                      <!-- End Filtrar -->

                      <?php if( $_GET['Filtrar'] == 'Ok' ){ ?>

                        <div class="col-sm-12"></div>

                        <!-- Excel -->
                        <div class="col-sm-4">
                          <div class="form-group">
                            <label class="control-label">.</label>

                            <!-- Btn Excel -->
                            <a href="excel.php<?php echo $Bus; ?>" target="_blank">
                              <button class="btn btn-secondary btn-block" type="button" name="button">
                                Excel Ventas y Pagos <i class="fa fa-file mar-l-5"></i>
                              </button>
                            </a>
                            <!-- End Btn Excel -->

                          </div>
                        </div>
                        <!-- End Excel -->

                        <!-- Excel Productos -->
                        <div class="col-sm-4">
                          <div class="form-group">
                            <label class="control-label">.</label>

                            <!-- Btn Excel -->
                            <a href="excel-productos.php<?php echo $Bus; ?>" target="_blank">
                              <button class="btn btn-secondary btn-block" type="button" name="button">
                                Excel Venta de producto <i class="fa fa-file mar-l-5"></i>
                              </button>
                            </a>
                            <!-- End Btn Excel -->

                          </div>
                        </div>
                        <!-- End Excel Productos -->

                        <!-- Excel Pagos -->
                        <div class="col-sm-4">
                          <div class="form-group">
                            <label class="control-label">.</label>

                            <!-- Btn Excel -->
                            <a href="excel-pagos.php<?php echo $Bus; ?>" target="_blank">
                              <button class="btn btn-secondary btn-block" type="button" name="button">
                                Excel Pagos <i class="fa fa-file mar-l-5"></i>
                              </button>
                            </a>
                            <!-- End Btn Excel Pagos -->

                          </div>
                        </div>
                        <!-- End Excel -->

                      <?php } ?>

                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Buscador -->

            <div class="col-sm-12">
              <div class="card">
                <div class="card-body">

                  <div class="row">

                    <?php
                      //Ventas
                      mysqli_data_seek($Ventas, 0);
                      while($Ven = mysqli_fetch_array($Ventas)) {

                        //Pagos
                        $Query = "
                          SELECT
                            pag.Id,
                            pag.Fecha, pag.Pago,
                            met.Metodo
                          FROM KB_Pagos pag
                          LEFT JOIN KB_PagosMetodos met ON met.Id = pag.Fk_Metodo
                            WHERE pag.Fk_Venta = '$Ven[Id]'
                          ORDER BY pag.Fecha DESC
                        ";
                        $Items = $mysqli->query($Query);
                        mysqli_data_seek($Items, 0);
                        while($Item = mysqli_fetch_array($Items)) {

                          if( $Item['Metodo'] == "Efectivo" ){
                            $_total_efectivo = $_total_efectivo + $Item['Pago'];
                          }

                          if( $Item['Metodo'] == "Tarjeta de Debito" ){
                            $_total_debito = $_total_debito + $Item['Pago'];
                          }

                          if( $Item['Metodo'] == "Tarjeta de Credito" ){
                            $_total_credito = $_total_credito + $Item['Pago'];
                          }

                          if( $Item['Metodo'] == "Transferencia Bancaria" ){
                            $_total_transferencia = $_total_transferencia + $Item['Pago'];
                          }

                        }
                      }
                    ?>



                    <!-- Total Efectivo -->
                    <div class="col-sm-3 text-left">
                      <label style="font-weight: 600;">Total Efectivo</label>
                      <p>
                        $ <?php echo number_format($_total_efectivo,2,'.',','); ?>
                      </p>
                    </div>
                    <!-- End Total Efectivo -->

                    <!-- Total Tarjeta de Debito -->
                    <div class="col-sm-3 text-left">
                      <label style="font-weight: 600;">Total Tarjeta de Débito</label>
                      <p>
                        $ <?php echo number_format($_total_debito,2,'.',','); ?>
                      </p>
                    </div>
                    <!-- End Total Tarjeta de Debito -->

                    <!-- Total Tarjeta de Crédito -->
                    <div class="col-sm-3 text-left">
                      <label style="font-weight: 600;">Total Tarjeta de Crédito</label>
                      <p>
                        $ <?php echo number_format($_total_credito,2,'.',','); ?>
                      </p>
                    </div>
                    <!-- End Total Tarjeta de Crédito -->

                    <!-- Total Transferencia -->
                    <div class="col-sm-3 text-left">
                      <label style="font-weight: 600;">Total Transferencia</label>
                      <p>
                        $ <?php echo number_format($_total_transferencia,2,'.',','); ?>
                      </p>
                    </div>
                    <!-- End Total Transferencia -->

                  </div>

                </div>
              </div>
            </div>

              <div class="col-12">
                <!-- Usuarios -->
                <div class="card">
                  <div class="card-body">
                    <div class="table-responsive m-t-20">
                      <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                          <tr>
                            <th>Venta</th>
                            <th>Tipo</th>
                            <th>Cliente</th>
                            <th>Pagos</th>
                            <th>Productos</th>
                            <th class="text-right">Total</th>
                          </tr>
                        </thead>
                        <tbody>
                            <?php
                              //Ventas
                              mysqli_data_seek($Ventas, 0);
                              while($Ven = mysqli_fetch_array($Ventas)) {
                            ?>
                              <tr>

                                <!-- Documento -->
                                <td class="text-left">
                                  <div>
                                    <i class="fa fa-file m-r-5"></i>
                                    <?php echo $Ven['Documento']; ?>
                                  </div>
                                  <div>
                                    <i class="fa fa-calendar m-r-5"></i>
                                    <?php echo CambioFechaInversa(date('Y-m-d', strtotime($Ven['Fecha']))); ?>
                                  </div>
                                  <div>
                                    <i class="fa fa-clock-o m-r-5"></i>
                                    <?php echo date('H:i', strtotime($Ven['Fecha'])); ?>
                                  </div>
                                </td>
                                <!-- End Documento -->

                                <!-- Tipo -->
                                <td class="text-left">
                                  <div><?php
                                    if( $Ven['FechaCarga'] ){
                                      echo 'Externa';
                                    }else{
                                      echo 'Interna';
                                    }
                                  ?></div>
                                </td>
                                <!-- End Tipo -->

                                <!-- Cliente -->
                                <td class="text-left">
                                  <div><?php echo $Ven['Cliente']; ?></div>
                                </td>
                                <!-- End Cliente -->

                                <!-- Pagos -->
                                <td class="text-left">
                                  <table
                                    style="width:100%;"
                                  >
                                    <thead>
                                      <tr>
                                        <td style="background: #f0f0f0;">
                                          Fecha
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Forma
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Pago
                                        </td>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php
                                        //Pagos
                                        $Query = "
                                          SELECT
                                            pag.Id,
                                            pag.Fecha, pag.Pago,
                                            met.Metodo
                                          FROM KB_Pagos pag
                                          LEFT JOIN KB_PagosMetodos met ON met.Id = pag.Fk_Metodo
                                            WHERE pag.Fk_Venta = '$Ven[Id]'
                                          ORDER BY pag.Fecha DESC
                                        ";
                                        $Items = $mysqli->query($Query);
                                        mysqli_data_seek($Items, 0);
                                        while($Item = mysqli_fetch_array($Items)) {
                                      ?>
                                        <?php if( $Item[Pago] > 0 ){ ?>
                                          <tr>
                                            <td>
                                              <?php echo CambioFechaInversa(date('Y-m-d', strtotime($Item['Fecha']))); ?>
                                            </td>
                                            <td style="width:100px;" class="text-right">
                                              <?php echo $Item[Metodo]; ?>
                                            </td>
                                            <td style="width:100px;" class="text-right">
                                              <div><?php
                                                $TotalPagos = $TotalPagos + $Item['Pago'];
                                                echo number_format($Item['Pago'],2,'.',',');
                                              ?></div>
                                            </td>
                                          </tr>
                                        <?php } ?>
                                      <?php } ?>
                                    </tbody>
                                  </table>
                                </td>
                                <!-- End Pagos -->

                                <!-- Productos -->
                                <td class="text-left">
                                  <table
                                    style="width:100%;"
                                  >
                                    <thead>
                                      <tr>
                                        <td style="background: #f0f0f0;">
                                          Clave Pro.
                                        </td>
                                        <td style="background: #f0f0f0;">
                                          Prod.
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Cantidad
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Precio
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Total
                                        </td>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php
                                        //Productos
                                        $Query = "
                                          SELECT
                                            pro.Id,
                                            pro.ProductoClave,
                                            pro.Cantidad,
                                            pro.Precio,
                                            pro.Descuento,
                                            pro.Total,
                                            pr.Nombre
                                          FROM KB_VentasProductos pro
                                          LEFT JOIN KB_Productos pr ON pr.Clave = pro.ProductoClave
                                            WHERE pro.Fk_Venta = '$Ven[Id]'
                                          ORDER BY pro.Id DESC
                                        ";
                                        $Items = $mysqli->query($Query);
                                        mysqli_data_seek($Items, 0);
                                        while($Item = mysqli_fetch_array($Items)) {
                                      ?>
                                        <tr>
                                          <td>
                                            <?php echo $Item[ProductoClave]; ?>
                                          </td>
                                          <td>
                                            <?php echo $Item[Nombre]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <?php echo $Item[Cantidad]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <?php echo $Item[Precio]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <div><?php
                                              $TotalProductos = $TotalProductos + $Item['Total'];
                                              echo number_format($Item['Total'],2,'.',',');
                                            ?></div>
                                          </td>
                                        </tr>
                                      <?php } ?>
                                    </tbody>
                                  </table>
                                </td>
                                <!-- End Productos -->

                                <!-- Monto -->
                                <td class="text-right">
                                  <div><?php
                                    $TotalTotal = $TotalTotal + $TotalTotal;
                                    echo number_format($Ven['Total'],2,'.',',');
                                  ?></div>
                                </td>
                                <!-- End Monto -->

                                <!-- Destacado --
                                <td>
                                  <?php if( $Ven[Destacado] == 1 ){ ?>
                                    <span class="label label-success">
                                      Destacado
                                    </span>
                                  <?php } ?>
                                </td>
                                <!-- End Destacado -->

                              </tr>
                            <?php } ?>
                          </tbody>
                          <tfoot>
                            <tr>

                              <td class="text-right" colspan="3">
                                <strong>Totales:</strong>
                              </td>

                              <!-- TotalPagos -->
                              <td class="text-right">
                                <?php echo number_format($TotalPagos,2,'.',',');  ?>
                              </td>
                              <!-- End TotalPagos -->

                              <!-- TotalProductos -->
                              <td class="text-right">
                                <?php echo number_format($TotalProductos,2,'.',',');  ?>
                              </td>
                              <!-- End TotalProductos -->

                              <!-- TotalTotal -->
                              <td class="text-right">
                                <?php echo number_format($TotalTotal,2,'.',',');  ?>
                              </td>
                              <!-- End TotalTotal -->

                            </tr>
                          </tfoot>
                      </table>
                    </div>
                  </div>
                </div>
                <!-- End Usuarios -->
              </div>
            </div>
        </div>
        <?php require_once($Position.'footer.php'); ?>
      </div>
    </div>
    <?php require_once($Position.'scripts.php'); ?>
    <script>

    </script>
    <script src="<?php echo $Position; ?>assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>

</body>
</html>
