<?php

  $debugin              = $decoded['debug'];
  $fecha_inicio         = $decoded['fecha_inicio'];
  $fecha_fin            = $decoded['fecha_fin'];
  $clave                = $decoded['clave'];

  if( $fecha_inicio && $fecha_fin ){

    $WHERE = "
      WHERE ven.Id != '0'
    ";

    if( $fecha_inicio && $fecha_fin ){

      $Des = $fecha_inicio.' 00:00:00';
      $Has = $fecha_fin.' 23:59:59';

      $WHERE .= "
        AND ( ven.Fecha BETWEEN '$Des' AND '$Has' )
      ";

    }

    //Ventas
    $Query = "
      SELECT
        ven.Id,
        ven.Fk_Usuario,
        ven.Fk_Cliente,
        ven.Fk_Empresa,
        ven.Pre, ven.Numero,
        CONCAT(ven.Pre,'-',ven.Numero) AS Doc,
        ven.Sucursal,
        ven.Documento, ven.Fecha,
        ven.Moneda, ven.Impuestos,
        ven.Total, ven.Saldo,
        ven.Factura, ven.Observaciones,
        ven.ObservacionesParticulares
      FROM KB_Ventas ven
      $WHERE
    ";
    $Vens = $mysqli->query($Query);
    mysqli_data_seek($Vens, 0);
    while($Ven = mysqli_fetch_array($Vens)) {

      //Empresa
      $Query = "
        SELECT
          emp.Id,
          emp.Clave,
          emp.Nombre
        FROM KB_Empresas emp
        WHERE
          emp.Id = '$Ven[Fk_Empresa]'
      ";
      $Result = mysqli_query($mysqli, $Query);
      $EmpresaVenta = mysqli_fetch_assoc($Result);

      //Productos
      $Query = "
        SELECT
          pro.Id,
          pro.ProductoClave,
          pro.Cantidad, pro.Precio,
          pro.Descuento, pro.Total
        FROM KB_VentasProductos pro
        WHERE
          pro.Fk_Venta = '$Ven[Id]'
        ORDER BY pro.Id ASC
      ";
      $Pros = $mysqli->query($Query);
      mysqli_data_seek($Pros, 0);
      while($Pro = mysqli_fetch_array($Pros)) {
        $Productos[$Ven[Id]][] = array(
          'produto_clave'     => "$Pro[ProductoClave]",
          'cantidad'          => "$Pro[Cantidad]",
          'precio'            => "$Pro[Precio]",
          'descuento'         => "$Pro[Descuento]",
          'total'             => "$Pro[Total]"
        );

      }
      //End Productos

      //Pagos
      $Query = "
        SELECT
          pag.Id,
          pag.Fecha, pag.Pago,
          met.Metodo
        FROM KB_Pagos pag
        LEFT JOIN KB_PagosMetodos met ON met.Id = pag.Fk_Metodo
        WHERE
          pag.Fk_Venta = '$Ven[Id]'
        ORDER BY pag.Fecha ASC
      ";
      $Pags = $mysqli->query($Query);
      mysqli_data_seek($Pags, 0);
      while($Pag = mysqli_fetch_array($Pags)) {

        $FechaPago = date('Y-m-d', strtotime($Pag[Fecha]));
        $HoraPago  = date('H:i', strtotime($Pag[Fecha]));

        if( $Pag[Pago] <= 0 ){
        }else{
          $Pagos[$Ven[Id]][] = array(
            'fecha_pago'      => "$FechaPago",
            'hora_pago'       => "$HoraPago",
            'cantidad_pago'   => "$Pag[Pago]",
            'metodo_pago'     => "$Pag[Metodo]"
          );
        }

      }
      //End Pagos

      $FechaVenta = date('Y-m-d', strtotime($Ven[Fecha]));
      $HoraVenta  = date('H:i', strtotime($Ven[Fecha]));

      //Datos de Usuario
      $Query = "
        SELECT
          usr.Id,
          CONCAT(usr.Nombre,' ',usr.Apellidos) AS Nombre
        FROM KB_Usuarios usr
        WHERE
          usr.Id = '$Ven[Fk_Usuario]'
      ";
      $Result = mysqli_query($mysqli, $Query);
      $UserVenta = mysqli_fetch_assoc($Result);

      if( $UserVenta[Id] ){
        $UsuarioVenta[$Ven[Id]][] = array(
          'id_user'      => "$UserVenta[Id]",
          'nombre_user'  => "$UserVenta[Nombre]",
        );
      }else{
        $UsuarioVenta[$Ven[Id]][] = "";
      }

      //Datos de Cliente
      $Query = "
        SELECT
          cli.Id,
          cli.Nombre, cli.Rfc, cli.Pasaporte,
          cli.Email, cli.Telefono, cli.Pcr_Num,
          fac.Clave AS FacClave, fac.Uso
        FROM KB_Clientes cli
        LEFT JOIN KB_FacturasUsos fac ON fac.Id = cli.Fk_UsoCfdi
        WHERE
          cli.Id = '$Ven[Fk_Cliente]'
      ";
      $Result = mysqli_query($mysqli, $Query);
      $Cli = mysqli_fetch_assoc($Result);

      if( $Cli[Pcr_Num] ){
        $Pcr_Num = $Cli[Pcr_Num];
      }else{
        $Pcr_Num = 0;
      }

      // $Cliente = "";

      $Cliente[$Ven[Id]][] = array(
        'nombre'          => "$Cli[Nombre]",
        'rfc'             => "$Cli[Rfc]",
        'pasaporte'       => "$Cli[Pasaporte]",
        'email'           => "$Cli[Email]",
        'telefono'        => "$Cli[Telefono]",
        'uso_cfdi_clave'  => "$Cli[FacClave]",
        'uso_cfdi'        => "$Cli[Uso]",
        'pcr'             => "$Pcr_Num"
      );

      //End Datos de Cliente

      // var_dump($Productos);

      if( $EmpresaVenta[Id] ){
        $Empresa = array(
          'empresa_clave' => $EmpresaVenta[Clave],
          'empresa_nombre' => $EmpresaVenta[Nombre]
        );
      }else{
        $Empresa = array(
          'empresa_clave' => '0',
          'empresa_nombre' => 'Sin empresa'
        );
      }

      $Ventas[] = array(
        'usuario'           => $UsuarioVenta[$Ven[Id]],
        'empresa'           => $Empresa,
        'cliente'           => $Cliente[$Ven[Id]],
        'fecha'             => "$FechaVenta",
        'hora'              => "$HoraVenta",
        'documento'         => "$Ven[Doc]",
        'moneda'            => "$Ven[Moneda]",
        'impuestos'         => "$Ven[Impuestos]",
        'total'             => "$Ven[Total]",
        'saldo'             => "$Ven[Saldo]",
        'factura'           => "$Ven[Factura]",
        'sucursal'          => "$Ven[Sucursal]",
        'productos'         => $Productos[$Ven[Id]],
        'pagos'             => $Pagos[$Ven[Id]],
        'observaciones'     => "$Ven[Observaciones]",
        'observaciones_particulares' => "$Ven[ObservacionesParticulares]"
      );

    }

    //Respuesta
    $Data = array(
      'action'              => 'ok',
      'ventas'               => $Ventas
    );
    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

  }else{

    //Error
    $Query = "
      SELECT
        err.Id, err.error, err.msn
      FROM KB_Api_Errores err
      WHERE err.error = 'pro-3'
    ";
    $Result = mysqli_query($mysqli, $Query);
    $Error = mysqli_fetch_assoc($Result);

    $Data = array(
      'action'      => 'error',
      'error'       => $Error[error],
      'error_msn'   => $Error[msn]
    );
    echo json_encode($Data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

  }
?>
